  % An example to use the m-file of NSI_calculate.m
 
  % You  can use the code freely, please cite the following artical:
  % Ming Li, Xue Mei Song, Tao Xu, et al., Subdomains within orientation columns of primary visual cortex, Science Advances,  Volume 5(6):eaaw0807, 2019, DOI: 10.1126/sciadv.aaw0807

  % DataAry: A array storing the aligned LFP data.
  %1st dimension: the length of timecourse, which is recommend to be 150ms
  %2nd dim: orientaions
  %3rd dim: repeats

clear
ccc = dir('PathMemory_nevFile.mat');
if length(ccc)
    load('PathMemory_nevFile.mat','PATHNAME');
else
    PATHNAME = '//';
end
if ~isstr(PATHNAME)
    PATHNAME = '//';
end

[FILENAME, PATHNAME] = uigetfile('*.mat','select the data file',PATHNAME);
fn = [PATHNAME,FILENAME];
load([PATHNAME,FILENAME],'newSampleRate','DataAry');

DataAry = squeeze(DataAry);
       
Chn_Num = size(DataAry, 6);
TAIL_Length = size(DataAry, 1);
OrientationNumber = size(DataAry,2);
Orientations = 0:180/OrientationNumber:179;

DataAry_mean = reshape( mean(mean(DataAry,3),4), TAIL_Length,  OrientationNumber);

DataAry_mean = DataAry_mean - repmat(mean(DataAry_mean,2),1,OrientationNumber);
            
[U,S,PCA_r] = svd(DataAry_mean');
            
for i = round(OrientationNumber/2):-1:1   % only check the first 1/2 components is enough
            figtemp = figure('defaultuicontrolunits','normalized','menubar','none','toolbar','figure','unit','normalized','position',[0+0.6/OrientationNumber*2*(i-1),0.5-0.6/OrientationNumber*2*(i-1),0.4,0.4]);
            set(gcf,'Name',[num2str(i),' of ',num2str(OrientationNumber-1)])

            h = subplot(1,2,1);
            temp = U(:,i);
            plot([Orientations,Orientations(1)+180],[temp;temp(1)],'--o');
            set(get(h,'XLabel'),'string','LFP tunning');
          
            x = Orientations;
            y = temp';

            UDtemp.x = x;
            UDtemp.y = y;
            set(gcf,'Userdata',UDtemp);
            h=uicontrol('style','pushbutton','position',[0.15,0.2,0.3,0.08],'fontsize',9,'string',['Calculate NSI of this curve'],'callback','NSI_Calculate','tag','Tag_Fit','BackgroundColor',[0 0.5 0.2],'ForegroundColor',[1 1 1]); 
            
            h = subplot(1,2,2)
            plot((1:TAIL_Length)/newSampleRate,PCA_r(:,i))
            set(get(h,'XLabel'),'string','The time course');
            UDtemp.Response = PCA_r(:,i);
end